/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.world;

import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InfoLineSlimeChunk
extends InfoLine {
    private static final String SLIME_KEY = "minihud.info_line.slime_chunk";

    public InfoLineSlimeChunk(InfoToggle type) {
        super(type);
    }

    public InfoLineSlimeChunk() {
        this(InfoToggle.SLIME_CHUNK);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        String result;
        if (ctx.world() == null || ctx.pos() == null) {
            return null;
        }
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (!MiscUtils.isOverworld(ctx.world())) {
            return null;
        }
        if (this.getHudData().isWorldSeedKnown(ctx.world())) {
            long seed = this.getHudData().getWorldSeed(ctx.world());
            result = MiscUtils.canSlimeSpawnAt(ctx.pos().method_10263(), ctx.pos().method_10260(), seed) ? this.qt("minihud.info_line.slime_chunk.yes", new Object[0]) : this.qt("minihud.info_line.slime_chunk.no", new Object[0]);
        } else {
            result = this.qt("minihud.info_line.slime_chunk.no_seed", new Object[0]);
        }
        list.add(this.translate(SLIME_KEY, result));
        return list;
    }
}

