/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigColorList;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.interfaces.IConfigGui;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.widgets.WidgetColorListEdit;
import fi.dy.masa.malilib.gui.widgets.WidgetColorListEditEntry;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import javax.annotation.Nullable;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class GuiColorListEdit
extends GuiListBase<Color4f, WidgetColorListEditEntry, WidgetColorListEdit> {
    protected final IConfigColorList config;
    protected final IConfigGui configGui;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    protected int labelWidth;
    protected int textFieldWidth;
    @Nullable
    protected final IDialogHandler dialogHandler;

    public GuiColorListEdit(IConfigColorList config, IConfigGui configGui, @Nullable IDialogHandler dialogHandler, class_437 parent) {
        super(0, 0);
        this.config = config;
        this.configGui = configGui;
        this.dialogHandler = dialogHandler;
        this.title = StringUtils.translate("malilib.gui.title.color_list_edit", config.getName());
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
    }

    protected void setWidthAndHeight() {
        this.dialogWidth = 400;
        this.dialogHeight = GuiUtils.getScaledWindowHeight() - 90;
    }

    protected void centerOnScreen() {
        if (this.getParent() != null) {
            this.dialogLeft = this.getParent().field_22789 / 2 - this.dialogWidth / 2;
            this.dialogTop = this.getParent().field_22790 / 2 - this.dialogHeight / 2;
        } else {
            this.dialogLeft = 20;
            this.dialogTop = 20;
        }
    }

    @Override
    public void initGui() {
        this.setWidthAndHeight();
        this.centerOnScreen();
        this.reCreateListWidget();
        super.initGui();
    }

    public IConfigColorList getConfig() {
        return this.config;
    }

    @Override
    protected int getBrowserWidth() {
        return this.dialogWidth - 14;
    }

    @Override
    protected int getBrowserHeight() {
        return this.dialogHeight - 30;
    }

    @Override
    protected WidgetColorListEdit createListWidget(int listX, int listY) {
        return new WidgetColorListEdit(this.dialogLeft + 10, this.dialogTop + 20, this.getBrowserWidth(), this.getBrowserHeight(), this.dialogWidth - 100, this);
    }

    @Override
    public void method_25432() {
        if (((WidgetColorListEdit)this.getListWidget()).wereConfigsModified()) {
            ((WidgetColorListEdit)this.getListWidget()).applyPendingModifications();
            ConfigManager.getInstance().onConfigsChanged(this.configGui.getModId());
        }
        super.method_25432();
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(drawContext, mouseX, mouseY, partialTicks);
        }
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawScreenBackground(class_332 drawContext, int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(drawContext, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(drawContext, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }
}

