/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.data.ServerDataSyncer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4836;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class InventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final InventoryOverlayHandler INSTANCE = new InventoryOverlayHandler();
    InventoryOverlay.Context context = null;
    InventoryOverlay.Refresher refresher = null;
    IDataSyncer syncer = null;
    private Pair<class_2338, InventoryOverlay.Context> lastBlockEntityContext = null;
    private Pair<Integer, InventoryOverlay.Context> lastEntityContext = null;

    public static InventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    public String getModId() {
        return "tweakeroo";
    }

    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = ServerDataSyncer.getInstance();
        }
        return this.syncer;
    }

    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    public InventoryOverlay.Refresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    public boolean isEmpty() {
        return this.context == null;
    }

    @Nullable
    public InventoryOverlay.Context getRenderContextNullable() {
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getRenderContext(class_332 drawContext, class_3695 profiler, class_310 mc) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            this.renderInventoryOverlay(drawContext, this.getRenderContextNullable(), mc, Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), Configs.Generic.INVENTORY_PREVIEW_VILLAGER_BG_COLOR.getBooleanValue());
        }
        profiler.method_15407();
        return this.getRenderContextNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public InventoryOverlay.Context getTargetInventory(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null || mc.field_1687 == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = cameraEntity != mc.field_1724 ? RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, (class_1297)cameraEntity, (class_3959.class_242)class_3959.class_242.field_1348) : mc.field_1765;
        class_2487 nbt = new class_2487();
        if (trace == null || trace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            if (!(blockTmp instanceof class_2343)) return null;
            if (world instanceof class_3218) {
                be = world.method_8500(pos).method_8321(pos);
                if (be != null) {
                    nbt = be.method_38242((class_7225.class_7874)world.method_30349());
                }
            } else {
                Pair pair = this.requestBlockEntityAt(world, pos);
                if (pair != null) {
                    nbt = (class_2487)pair.getRight();
                }
            }
            InventoryOverlay.Context ctx = this.getTargetInventoryFromBlock(world, pos, be, nbt);
            if (this.lastBlockEntityContext != null && !((class_2338)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) {
                this.lastBlockEntityContext = null;
            }
            if (ctx != null && ctx.inv() != null) {
                this.lastBlockEntityContext = Pair.of((Object)pos, (Object)ctx);
                this.context = ctx;
                return this.context;
            }
            if (this.lastBlockEntityContext == null || !((class_2338)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) return null;
            this.context = (InventoryOverlay.Context)this.lastBlockEntityContext.getRight();
            return this.context;
        }
        if (trace.method_17783() != class_239.class_240.field_1331) return null;
        class_1297 entity = ((class_3966)trace).method_17782();
        if (world instanceof class_3218) {
            if ((entity = world.method_8469(entity.method_5628())) == null) return null;
            NbtView view = NbtView.getWriter((class_5455)world.method_30349());
            entity.method_5647(view.getWriter());
            nbt = view.readNbt();
            class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
            if (nbt != null && id != null) {
                nbt.method_10582("id", id.toString());
            }
        } else {
            Pair pair = this.getDataSyncer().requestEntity(world, entity.method_5628());
            if (pair != null) {
                nbt = (class_2487)pair.getRight();
            }
        }
        InventoryOverlay.Context ctx = this.getTargetInventoryFromEntity(world.method_8469(entity.method_5628()), nbt);
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.method_5628()) {
            this.lastEntityContext = null;
        }
        if (ctx != null && ctx.inv() != null && !ctx.inv().method_5442()) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() != null && ctx.inv().method_5442() && ctx.nbt() != null && ctx.nbt().method_10545("Offers")) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() == null && (ctx.type() == InventoryOverlay.InventoryRenderType.WOLF || ctx.type() == InventoryOverlay.InventoryRenderType.VILLAGER || ctx.type() == InventoryOverlay.InventoryRenderType.HORSE || ctx.type() == InventoryOverlay.InventoryRenderType.PLAYER || ctx.type() == InventoryOverlay.InventoryRenderType.ARMOR_STAND || ctx.type() == InventoryOverlay.InventoryRenderType.LIVING_ENTITY)) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() == entity.method_5628() && ctx != null && ctx.inv() != null && ctx.inv().method_5442() && (ctx.type() == InventoryOverlay.InventoryRenderType.VILLAGER || ctx.type() == InventoryOverlay.InventoryRenderType.HORSE || ctx.type() == InventoryOverlay.InventoryRenderType.PLAYER)) {
            this.context = (InventoryOverlay.Context)this.lastEntityContext.getRight();
            return this.context;
        }
        if (this.lastEntityContext == null || ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.method_5628()) return null;
        this.context = (InventoryOverlay.Context)this.lastEntityContext.getRight();
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, class_2487 nbt) {
        Pair enderPair;
        class_1730 enderItems;
        class_1657 player;
        class_2591 beType;
        class_1263 inv;
        if (world == null) {
            return null;
        }
        if (be != null) {
            if (nbt.method_33133()) {
                nbt = be.method_38242((class_7225.class_7874)world.method_30349());
            }
            inv = InventoryUtils.getInventory((class_1937)world, (class_2338)pos);
        } else {
            Pair pair;
            if (nbt.method_33133() && (pair = this.requestBlockEntityAt(world, pos)) != null) {
                nbt = (class_2487)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        class_2591 class_25912 = beType = nbt != null ? NbtBlockUtils.getBlockEntityTypeFromNbt((class_2487)nbt) : null;
        if ((beType != null && beType.equals(class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null && (enderItems = (enderPair = this.getDataSyncer().requestEntity(world, player.method_5628())) != null && enderPair.getRight() != null && ((class_2487)enderPair.getRight()).method_10545("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)((class_2487)enderPair.getRight()), (class_5455)world.method_30349()) : player.method_7274()) != null) {
            inv = enderItems;
        }
        if (nbt != null && !nbt.method_33133()) {
            class_1263 inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)(inv != null ? inv.method_5439() : -1), (class_5455)world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        if (inv == null || nbt == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType((class_1263)inv, (class_2487)nbt), inv, be != null ? be : world.method_8321(pos), null, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(class_1297 entity, class_2487 nbt) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().method_67533().toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1646) {
            inv = ((class_1646)entity).method_35199();
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_4836) {
            inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
        }
        if (!nbt.method_33133()) {
            class_1263 inv2;
            if (inv != null && nbt.method_10545("Items") && nbt.method_68569("Items").size() > 1) {
                inv2 = entity instanceof class_1496 ? InventoryUtils.getNbtInventoryHorseFix((class_2487)nbt, (int)-1, (class_5455)entity.method_56673()) : InventoryUtils.getNbtInventory((class_2487)nbt, (int)-1, (class_5455)entity.method_56673());
                inv = null;
            } else if (inv != null && nbt.method_10545("equipment") && nbt.method_10545("EatingHaystack")) {
                inv2 = InventoryUtils.getNbtInventoryHorseFix((class_2487)nbt, (int)-1, (class_5455)entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && nbt.method_10545("Inventory") && !nbt.method_68569("Inventory").isEmpty()) {
                inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)8, (class_5455)entity.method_56673());
                inv = null;
            } else {
                inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)(inv != null ? inv.method_5439() : -1), (class_5455)entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType((class_1263)inv, (class_2487)nbt) : InventoryOverlay.getInventoryType((class_2487)nbt), inv, null, entityLivingBase, nbt, this.getRefreshHandler());
        return this.context;
    }

    private static void dumpContext(InventoryOverlay.Context ctx) {
        System.out.print("Context Dump --> ");
        if (ctx == null) {
            System.out.print("NULL!\n");
            return;
        }
        System.out.printf("\nTYPE: [%s]\n", ctx.type().name());
        System.out.printf("BE  : [%s]\n", ctx.be() != null ? class_7923.field_41181.method_10221((Object)ctx.be().method_11017()) : "<NULL>");
        System.out.printf("ENT : [%s]\n", ctx.entity() != null ? class_7923.field_41177.method_10221((Object)ctx.entity().method_5864()) : "<NULL>");
        System.out.printf("INV : [%s]\n", ctx.inv() != null ? "size: " + ctx.inv().method_5439() + "/ empty: " + ctx.inv().method_5442() : "<NULL>");
        System.out.printf("NBT : [%s]\n", ctx.nbt() != null ? ctx.nbt().toString() : "<NULL>");
        System.out.print("--> EOF\n");
    }

    public static class Refresher
    implements InventoryOverlay.Refresher {
        public InventoryOverlay.Context onContextRefresh(InventoryOverlay.Context data, class_1937 world) {
            if (data.be() != null) {
                InventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().method_11016());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().method_10997(), data.be().method_11016(), data.be(), data.nbt());
            } else if (data.entity() != null) {
                InventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().method_5628());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((class_1297)data.entity(), data.nbt());
            }
            return data;
        }
    }
}

