/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class BlockValue
extends Value {
    private class_2680 blockState;
    private final class_2338 pos;
    private final class_3218 world;
    private class_2487 data;
    public static final BlockValue NONE = new BlockValue(class_2246.field_10124.method_9564(), null, class_2338.field_10980, null);
    private static final Map<String, BlockValue> bvCache = new HashMap<String, BlockValue>();

    public static BlockValue fromCoords(CarpetContext c, int x, int y, int z) {
        class_2338 pos = BlockValue.locateBlockPos(c, x, y, z);
        return new BlockValue(null, c.level(), pos);
    }

    public static BlockValue fromString(String str, class_3218 level) {
        try {
            BlockValue bv = bvCache.get(str);
            if (bv != null) {
                return bv;
            }
            class_2259.class_7211 foo = class_2259.method_41955((class_7225)level.method_30349().method_30530(class_7924.field_41254), (StringReader)new StringReader(str), (boolean)true);
            if (foo.comp_622() != null) {
                class_2487 bd = foo.comp_624();
                if (bd == null) {
                    bd = new class_2487();
                }
                bv = new BlockValue(foo.comp_622(), level, null, bd);
                if (bvCache.size() > 10000) {
                    bvCache.clear();
                }
                bvCache.put(str, bv);
                return bv;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        throw new ThrowStatement(str, Throwables.UNKNOWN_BLOCK);
    }

    public static class_2338 locateBlockPos(CarpetContext c, int xpos, int ypos, int zpos) {
        class_2338 pos = c.origin();
        return new class_2338(pos.method_10263() + xpos, pos.method_10264() + ypos, pos.method_10260() + zpos);
    }

    public class_2680 getBlockState() {
        if (this.blockState != null) {
            return this.blockState;
        }
        if (this.pos != null) {
            this.blockState = this.world.method_8320(this.pos);
            return this.blockState;
        }
        throw new InternalExpressionException("Attempted to fetch block state without world or stored block state");
    }

    public static class_2586 getBlockEntity(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return serverLevel.method_8503().method_18854() ? serverLevel.method_8321(pos) : serverLevel.method_8500(pos).method_12201(pos, class_2818.class_2819.field_12860);
        }
        return null;
    }

    public class_2487 getData() {
        if (this.data != null) {
            return this.data.method_33133() ? null : this.data;
        }
        if (this.pos != null) {
            class_2586 be = BlockValue.getBlockEntity((class_1937)this.world, this.pos);
            if (be == null) {
                this.data = new class_2487();
                return null;
            }
            this.data = be.method_38244((class_7225.class_7874)be.method_10997().method_30349());
            return this.data;
        }
        return null;
    }

    public BlockValue(class_2680 state, class_3218 world, class_2338 position) {
        this.world = world;
        this.blockState = state;
        this.pos = position;
        this.data = null;
    }

    public BlockValue(class_2680 state) {
        this.world = null;
        this.blockState = state;
        this.pos = null;
        this.data = null;
    }

    public BlockValue(class_3218 world, class_2338 position) {
        this.world = world;
        this.blockState = null;
        this.pos = position;
        this.data = null;
    }

    public BlockValue(class_2680 state, class_2487 nbt) {
        this.world = null;
        this.blockState = state;
        this.pos = null;
        this.data = nbt;
    }

    public BlockValue(class_2680 state, class_3218 world, class_2487 nbt) {
        this.world = world;
        this.blockState = state;
        this.pos = null;
        this.data = nbt;
    }

    private BlockValue(@Nullable class_2680 state, @Nullable class_3218 world, @Nullable class_2338 position, @Nullable class_2487 nbt) {
        this.world = world;
        this.blockState = state;
        this.pos = position;
        this.data = nbt;
    }

    @Override
    public String getString() {
        class_2378 blockRegistry = this.world.method_30349().method_30530(class_7924.field_41254);
        return NBTSerializableValue.nameFromResource(blockRegistry.method_10221((Object)this.getBlockState().method_26204()));
    }

    @Override
    public boolean getBoolean() {
        return !this.getBlockState().method_26215();
    }

    @Override
    public String getTypeString() {
        return "block";
    }

    public Value clone() {
        return new BlockValue(this.blockState, this.world, this.pos, this.data);
    }

    @Override
    public int hashCode() {
        return this.pos != null ? class_4208.method_19443((class_5321)this.world.method_27983(), (class_2338)this.pos).hashCode() : ("b" + this.getString()).hashCode();
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    @Override
    public class_2520 toTag(boolean force, class_5455 regs) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        class_2487 tag = new class_2487();
        class_2487 state = new class_2487();
        class_2680 s = this.getBlockState();
        state.method_10566("Name", (class_2520)class_2519.method_23256((String)this.world.method_30349().method_30530(class_7924.field_41254).method_10221((Object)s.method_26204()).toString()));
        Collection properties = s.method_28501();
        if (!properties.isEmpty()) {
            class_2487 props = new class_2487();
            for (class_2769 p : properties) {
                props.method_10566(p.method_11899(), (class_2520)class_2519.method_23256((String)s.method_11654(p).toString().toLowerCase(Locale.ROOT)));
            }
            state.method_10566("Properties", (class_2520)props);
        }
        tag.method_10566("BlockState", (class_2520)state);
        class_2487 dataTag = this.getData();
        if (dataTag != null) {
            tag.method_10566("TileEntityData", (class_2520)dataTag);
        }
        return tag;
    }

    public static class PlacementContext
    extends class_1750 {
        private final class_2350 facing;
        private final boolean sneakPlace;

        public static PlacementContext from(class_1937 world, class_2338 pos, String direction, boolean sneakPlace, class_1799 itemStack) {
            SpecificDirection dir = SpecificDirection.DIRECTION_MAP.get(direction);
            if (dir == null) {
                throw new InternalExpressionException("unknown block placement direction: " + direction);
            }
            class_3965 hitres = new class_3965(class_243.method_24954((class_2382)pos).method_1019(dir.hitOffset), dir.facing, pos, false);
            return new PlacementContext(world, dir.facing, sneakPlace, itemStack, hitres);
        }

        private PlacementContext(class_1937 world_1, class_2350 direction_1, boolean sneakPlace, class_1799 itemStack_1, class_3965 hitres) {
            super(world_1, null, class_1268.field_5808, itemStack_1, hitres);
            this.facing = direction_1;
            this.sneakPlace = sneakPlace;
        }

        public class_2338 method_8037() {
            boolean prevcanReplaceExisting = this.field_7904;
            this.field_7904 = true;
            class_2338 ret = super.method_8037();
            this.field_7904 = prevcanReplaceExisting;
            return ret;
        }

        public class_2350 method_7715() {
            return this.facing.method_10153();
        }

        public class_2350[] method_7718() {
            class_2350[] class_2350Array;
            switch (this.facing) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_11033: {
                    class_2350[] class_2350Array2 = new class_2350[6];
                    class_2350Array2[0] = class_2350.field_11033;
                    class_2350Array2[1] = class_2350.field_11043;
                    class_2350Array2[2] = class_2350.field_11034;
                    class_2350Array2[3] = class_2350.field_11035;
                    class_2350Array2[4] = class_2350.field_11039;
                    class_2350Array = class_2350Array2;
                    class_2350Array2[5] = class_2350.field_11036;
                    break;
                }
                case field_11036: {
                    class_2350[] class_2350Array3 = new class_2350[6];
                    class_2350Array3[0] = class_2350.field_11033;
                    class_2350Array3[1] = class_2350.field_11036;
                    class_2350Array3[2] = class_2350.field_11043;
                    class_2350Array3[3] = class_2350.field_11034;
                    class_2350Array3[4] = class_2350.field_11035;
                    class_2350Array = class_2350Array3;
                    class_2350Array3[5] = class_2350.field_11039;
                    break;
                }
                case field_11043: {
                    class_2350[] class_2350Array4 = new class_2350[6];
                    class_2350Array4[0] = class_2350.field_11033;
                    class_2350Array4[1] = class_2350.field_11043;
                    class_2350Array4[2] = class_2350.field_11034;
                    class_2350Array4[3] = class_2350.field_11039;
                    class_2350Array4[4] = class_2350.field_11036;
                    class_2350Array = class_2350Array4;
                    class_2350Array4[5] = class_2350.field_11035;
                    break;
                }
                case field_11035: {
                    class_2350[] class_2350Array5 = new class_2350[6];
                    class_2350Array5[0] = class_2350.field_11033;
                    class_2350Array5[1] = class_2350.field_11035;
                    class_2350Array5[2] = class_2350.field_11034;
                    class_2350Array5[3] = class_2350.field_11039;
                    class_2350Array5[4] = class_2350.field_11036;
                    class_2350Array = class_2350Array5;
                    class_2350Array5[5] = class_2350.field_11043;
                    break;
                }
                case field_11039: {
                    class_2350[] class_2350Array6 = new class_2350[6];
                    class_2350Array6[0] = class_2350.field_11033;
                    class_2350Array6[1] = class_2350.field_11039;
                    class_2350Array6[2] = class_2350.field_11035;
                    class_2350Array6[3] = class_2350.field_11036;
                    class_2350Array6[4] = class_2350.field_11043;
                    class_2350Array = class_2350Array6;
                    class_2350Array6[5] = class_2350.field_11034;
                    break;
                }
                case field_11034: {
                    class_2350[] class_2350Array7 = new class_2350[6];
                    class_2350Array7[0] = class_2350.field_11033;
                    class_2350Array7[1] = class_2350.field_11034;
                    class_2350Array7[2] = class_2350.field_11035;
                    class_2350Array7[3] = class_2350.field_11036;
                    class_2350Array7[4] = class_2350.field_11043;
                    class_2350Array = class_2350Array7;
                    class_2350Array7[5] = class_2350.field_11039;
                }
            }
            return class_2350Array;
        }

        public class_2350 method_8042() {
            return this.facing.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11043 : this.facing;
        }

        public class_2350 method_32760() {
            return this.facing.method_10166() == class_2350.class_2351.field_11052 ? this.facing : class_2350.field_11036;
        }

        public boolean method_8046() {
            return this.sneakPlace;
        }

        public float method_8044() {
            return this.facing.method_10161() * 90;
        }
    }

    public static enum SpecificDirection {
        UP("up", 0.5, 0.0, 0.5, class_2350.field_11036),
        UPNORTH("up-north", 0.5, 0.0, 0.4, class_2350.field_11036),
        UPSOUTH("up-south", 0.5, 0.0, 0.6, class_2350.field_11036),
        UPEAST("up-east", 0.6, 0.0, 0.5, class_2350.field_11036),
        UPWEST("up-west", 0.4, 0.0, 0.5, class_2350.field_11036),
        DOWN("down", 0.5, 1.0, 0.5, class_2350.field_11033),
        DOWNNORTH("down-north", 0.5, 1.0, 0.4, class_2350.field_11033),
        DOWNSOUTH("down-south", 0.5, 1.0, 0.6, class_2350.field_11033),
        DOWNEAST("down-east", 0.6, 1.0, 0.5, class_2350.field_11033),
        DOWNWEST("down-west", 0.4, 1.0, 0.5, class_2350.field_11033),
        NORTH("north", 0.5, 0.4, 1.0, class_2350.field_11043),
        SOUTH("south", 0.5, 0.4, 0.0, class_2350.field_11035),
        EAST("east", 0.0, 0.4, 0.5, class_2350.field_11034),
        WEST("west", 1.0, 0.4, 0.5, class_2350.field_11039),
        NORTHUP("north-up", 0.5, 0.6, 1.0, class_2350.field_11043),
        SOUTHUP("south-up", 0.5, 0.6, 0.0, class_2350.field_11035),
        EASTUP("east-up", 0.0, 0.6, 0.5, class_2350.field_11034),
        WESTUP("west-up", 1.0, 0.6, 0.5, class_2350.field_11039);

        public final String name;
        public final class_243 hitOffset;
        public final class_2350 facing;
        private static final Map<String, SpecificDirection> DIRECTION_MAP;

        private SpecificDirection(String name, double hitx, double hity, double hitz, class_2350 blockFacing) {
            this.name = name;
            this.hitOffset = new class_243(hitx, hity, hitz);
            this.facing = blockFacing;
        }

        private String getName() {
            return this.name;
        }

        static {
            DIRECTION_MAP = Arrays.stream(SpecificDirection.values()).collect(Collectors.toMap(SpecificDirection::getName, d -> d));
        }
    }
}

