/*
 * Decompiled with CFR 0.152.
 */
package carpet.api.settings;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.Rule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.Validator;
import carpet.network.ServerNetworkHandler;
import carpet.script.Expression;
import carpet.settings.ParsedRule;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.Translations;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class SettingsManager {
    private final Map<String, CarpetRule<?>> rules = new HashMap();
    private final String version;
    private final String identifier;
    private final String fancyName;
    private boolean locked;
    private MinecraftServer server;
    private final List<RuleObserver> observers = new ArrayList<RuleObserver>();
    private static final List<RuleObserver> staticObservers = new ArrayList<RuleObserver>();

    public SettingsManager(String version, String identifier, String fancyName) {
        this.version = version;
        this.identifier = identifier;
        this.fancyName = fancyName;
    }

    public void registerRuleObserver(RuleObserver observer) {
        this.observers.add(observer);
    }

    public static void registerGlobalRuleObserver(RuleObserver observer) {
        staticObservers.add(observer);
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean locked() {
        return this.locked;
    }

    public void parseSettingsClass(Class<?> settingsClass) {
        Translations.updateLanguage();
        boolean warned = settingsClass == CarpetSettings.class;
        block2: for (Field field : settingsClass.getDeclaredFields()) {
            Class<? extends Rule.Condition>[] conditions;
            Rule newAnnotation = field.getAnnotation(Rule.class);
            carpet.settings.Rule oldAnnotation = field.getAnnotation(carpet.settings.Rule.class);
            if (newAnnotation != null) {
                conditions = newAnnotation.conditions();
            } else {
                if (oldAnnotation == null) continue;
                conditions = oldAnnotation.condition();
                if (!warned) {
                    CarpetSettings.LOG.warn("Registering outdated rules for settings class '%s'!\nThis won't be supported in the future and rules won't be registered!".formatted(settingsClass.getName()));
                    warned = true;
                }
            }
            for (Class<? extends Rule.Condition> condition : conditions) {
                try {
                    Constructor<? extends Rule.Condition> constr = condition.getDeclaredConstructor(new Class[0]);
                    constr.setAccessible(true);
                    if (constr.newInstance(new Object[0]).shouldRegister()) continue;
                    continue block2;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            ParsedRule parsed = ParsedRule.of(field, this);
            this.rules.put(parsed.name(), parsed);
        }
    }

    public Iterable<String> getCategories() {
        return this.getCarpetRules().stream().map(CarpetRule::categories).mapMulti(Iterable::forEach).collect(Collectors.toSet());
    }

    public CarpetRule<?> getCarpetRule(String name) {
        return this.rules.get(name);
    }

    public Collection<CarpetRule<?>> getCarpetRules() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    public void addCarpetRule(CarpetRule<?> rule) {
        if (this.rules.containsKey(rule.name())) {
            throw new UnsupportedOperationException(this.fancyName + " settings manager already contains a rule with that name!");
        }
        this.rules.put(rule.name(), rule);
    }

    public void notifyRuleChanged(class_2168 source, CarpetRule<?> rule, String userInput) {
        this.observers.forEach(observer -> observer.ruleChanged(source, rule, userInput));
        staticObservers.forEach(observer -> observer.ruleChanged(source, rule, userInput));
        ServerNetworkHandler.updateRuleWithConnectedClients(rule);
        this.switchScarpetRuleIfNeeded(source, rule);
    }

    public void attachServer(MinecraftServer server) {
        this.server = server;
        this.loadConfigurationFromConf();
    }

    public void detachServer() {
        for (CarpetRule<?> rule : this.rules.values()) {
            RuleHelper.resetToDefault(rule, null);
        }
        this.server = null;
    }

    public void initializeScarpetRules() {
        for (CarpetRule<?> rule : this.rules.values()) {
            if (!(rule instanceof ParsedRule)) continue;
            ParsedRule pr = (ParsedRule)rule;
            if (pr.scarpetApp.isEmpty()) continue;
            this.switchScarpetRuleIfNeeded(this.server.method_3739(), pr);
        }
    }

    public void inspectClientsideCommand(String string) {
        String[] res;
        if (string.startsWith("/" + this.identifier + " ") && (res = string.split("\\s+", 3)).length == 3) {
            String rule = res[1];
            String strOption = res[2];
            if (this.rules.containsKey(rule) && this.rules.get(rule).canBeToggledClientSide()) {
                try {
                    this.rules.get(rule).set((class_2168)null, strOption);
                }
                catch (InvalidRuleValueException invalidRuleValueException) {
                    // empty catch block
                }
            }
        }
    }

    private void switchScarpetRuleIfNeeded(class_2168 source, CarpetRule<?> carpetRule) {
        if (carpetRule instanceof ParsedRule) {
            ParsedRule rule = (ParsedRule)carpetRule;
            if (!rule.scarpetApp.isEmpty() && CarpetServer.scriptServer != null) {
                if (RuleHelper.getBooleanValue(rule) || rule.type() == String.class && !rule.value().equals("false")) {
                    CarpetServer.scriptServer.addScriptHost(source, rule.scarpetApp, s -> CommandHelper.canUseCommand(s, rule.value()), false, false, true, null, Expression.LoadOverride.DEFAULT);
                } else {
                    CarpetServer.scriptServer.removeScriptHost(source, rule.scarpetApp, false, true);
                }
            }
        }
    }

    private Path getFile() {
        return this.server.method_27050(class_5218.field_24188).resolve(this.identifier + ".conf");
    }

    private Collection<CarpetRule<?>> getRulesSorted() {
        return this.rules.values().stream().sorted(Comparator.comparing(CarpetRule::name)).toList();
    }

    private void disableBooleanCommands() {
        for (CarpetRule<?> rule : this.rules.values()) {
            if (!rule.categories().contains("command")) continue;
            try {
                if (rule.suggestions().contains("false")) {
                    rule.set(this.server.method_3739(), "false");
                    continue;
                }
                CarpetSettings.LOG.warn("Couldn't disable command rule " + rule.name() + ": it doesn't suggest false as a valid option");
            }
            catch (InvalidRuleValueException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void writeSettingsToConf(ConfigReadResult data) {
        if (this.locked) {
            return;
        }
        try (BufferedWriter fw = Files.newBufferedWriter(this.getFile(), new OpenOption[0]);){
            for (String key : data.ruleMap().keySet()) {
                fw.write(key + " " + data.ruleMap().get(key));
                fw.newLine();
            }
        }
        catch (IOException e) {
            CarpetSettings.LOG.error("[CM]: failed write " + this.identifier + ".conf config file", (Throwable)e);
        }
    }

    private Collection<CarpetRule<?>> findStartupOverrides() {
        Set<String> defaults = this.readSettingsFromConf(this.getFile()).ruleMap().keySet();
        return this.rules.values().stream().filter(r -> defaults.contains(r.name())).sorted(Comparator.comparing(CarpetRule::name)).toList();
    }

    private Collection<CarpetRule<?>> getNonDefault() {
        return this.rules.values().stream().filter(Predicate.not(RuleHelper::isInDefaultValue)).sorted(Comparator.comparing(CarpetRule::name)).toList();
    }

    private void loadConfigurationFromConf() {
        for (CarpetRule<?> rule : this.rules.values()) {
            RuleHelper.resetToDefault(rule, this.server.method_3739());
        }
        ConfigReadResult conf = this.readSettingsFromConf(this.getFile());
        this.locked = false;
        if (conf.locked()) {
            CarpetSettings.LOG.info("[CM]: " + this.fancyName + " features are locked by the administrator");
            this.disableBooleanCommands();
        }
        int loadedCount = 0;
        for (String key : conf.ruleMap().keySet()) {
            try {
                this.rules.get(key).set(this.server.method_3739(), conf.ruleMap().get(key));
                ++loadedCount;
            }
            catch (InvalidRuleValueException exc) {
                CarpetSettings.LOG.error("[CM Error]: Failed to load setting: " + key, (Throwable)exc);
            }
        }
        if (loadedCount > 0) {
            CarpetSettings.LOG.info("[CM] Loaded " + loadedCount + " settings from " + this.identifier + ".conf");
        }
        this.locked = conf.locked();
    }

    private ConfigReadResult readSettingsFromConf(Path path) {
        ConfigReadResult configReadResult;
        block22: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                String line = "";
                boolean confLocked = false;
                HashMap<String, String> result = new HashMap<String, String>();
                while ((line = reader.readLine()) != null) {
                    String[] fields;
                    if ("locked".equalsIgnoreCase(line = line.replaceAll("[\\r\\n]", ""))) {
                        confLocked = true;
                    }
                    if ((fields = line.split("\\s+", 2)).length <= 1 || result.isEmpty() && fields[0].startsWith("#") || fields[1].startsWith("#")) continue;
                    if (!this.rules.containsKey(fields[0])) {
                        CarpetSettings.LOG.error("[CM]: " + this.fancyName + " Setting " + fields[0] + " is not a valid rule - ignoring...");
                        continue;
                    }
                    result.put(fields[0], fields[1]);
                }
                configReadResult = new ConfigReadResult(result, confLocked);
                if (reader == null) break block22;
            }
            catch (Throwable line) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable confLocked) {
                            line.addSuppressed(confLocked);
                        }
                    }
                    throw line;
                }
                catch (NoSuchFileException e) {
                    if (path.equals(this.getFile()) && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                        Path defaultsPath = FabricLoader.getInstance().getConfigDir().resolve("carpet/default_" + this.identifier + ".conf");
                        try {
                            if (Files.notExists(defaultsPath, new LinkOption[0])) {
                                Files.createDirectories(defaultsPath.getParent(), new FileAttribute[0]);
                                Files.createFile(defaultsPath, new FileAttribute[0]);
                                try (BufferedWriter fw = Files.newBufferedWriter(defaultsPath, new OpenOption[0]);){
                                    fw.write("# This is " + this.fancyName + "'s default configuration file");
                                    fw.newLine();
                                    fw.write("# Settings specified here will be used when a world doesn't have a config file, but they will be completely ignored once the world has one.");
                                    fw.newLine();
                                }
                            }
                            return this.readSettingsFromConf(defaultsPath);
                        }
                        catch (IOException e2) {
                            CarpetSettings.LOG.error("Exception when loading fallback default config: ", (Throwable)e2);
                        }
                    }
                    return new ConfigReadResult(new HashMap<String, String>(), false);
                }
                catch (IOException e) {
                    CarpetSettings.LOG.error("Exception while loading Carpet rules from config", (Throwable)e);
                    return new ConfigReadResult(new HashMap<String, String>(), false);
                }
            }
            reader.close();
        }
        return configReadResult;
    }

    private Collection<CarpetRule<?>> getRulesMatching(String search) {
        String lcSearch = search.toLowerCase(Locale.ROOT);
        return this.rules.values().stream().filter(rule -> {
            if (rule.name().toLowerCase(Locale.ROOT).contains(lcSearch)) {
                return true;
            }
            for (String c : rule.categories()) {
                if (!c.equals(search)) continue;
                return true;
            }
            return Sets.newHashSet((Object[])RuleHelper.translatedDescription(rule).toLowerCase(Locale.ROOT).split("\\W+")).contains(lcSearch);
        }).sorted(Comparator.comparing(CarpetRule::name)).toList();
    }

    public int dumpAllRulesToStream(PrintStream ps, String category) {
        ps.println("# " + this.fancyName + " Settings");
        for (CarpetRule<?> rule : new TreeMap(this.rules).values()) {
            if (category != null && !rule.categories().contains(category)) continue;
            ps.println("## " + rule.name());
            ps.println(RuleHelper.translatedDescription(rule) + "  ");
            for (class_2561 extra : rule.extraInfo()) {
                ps.println(extra.getString() + "  ");
            }
            ps.println("* Type: `" + rule.type().getSimpleName() + "`  ");
            ps.println("* Default value: `" + RuleHelper.toRuleString(rule.defaultValue()) + "`  ");
            String options = rule.suggestions().stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "));
            if (!options.isEmpty()) {
                ps.println((rule.strict() ? "* Allowed" : "* Suggested") + " options: " + options + "  ");
            }
            ps.println("* Categories: " + rule.categories().stream().map(s -> "`" + s.toUpperCase(Locale.ROOT) + "`").collect(Collectors.joining(", ")) + "  ");
            if (rule instanceof ParsedRule) {
                boolean preamble = false;
                for (Validator validator : ((ParsedRule)rule).realValidators) {
                    if (validator.description() == null) continue;
                    if (!preamble) {
                        ps.println("* Additional notes:  ");
                        preamble = true;
                    }
                    ps.println("  * " + validator.description() + "  ");
                }
            }
            ps.println("  ");
        }
        return 1;
    }

    private CarpetRule<?> contextRule(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String ruleName = StringArgumentType.getString(ctx, (String)"rule");
        CarpetRule<?> rule = this.getCarpetRule(ruleName);
        if (rule == null) {
            throw new SimpleCommandExceptionType((Message)Messenger.c("rb " + Translations.tr("carpet.settings.command.unknown_rule") + ": " + ruleName)).create();
        }
        return rule;
    }

    static CompletableFuture<Suggestions> suggestMatchingContains(Stream<String> stream, SuggestionsBuilder suggestionsBuilder) {
        ArrayList regularSuggestionList = new ArrayList();
        ArrayList smartSuggestionList = new ArrayList();
        String query = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        stream.forEach(listItem -> {
            List words = Arrays.stream(listItem.split("(?<!^)(?=[A-Z])")).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            ArrayList<String> prefixes = new ArrayList<String>(words.size());
            for (int i = 0; i < words.size(); ++i) {
                prefixes.add(String.join((CharSequence)"", words.subList(i, words.size())));
            }
            if (prefixes.stream().anyMatch(s -> s.startsWith(query))) {
                smartSuggestionList.add(listItem);
            }
            if (class_2172.method_27136((String)query, (String)listItem.toLowerCase(Locale.ROOT))) {
                regularSuggestionList.add(listItem);
            }
        });
        ArrayList filteredSuggestionList = regularSuggestionList.isEmpty() ? smartSuggestionList : regularSuggestionList;
        Objects.requireNonNull(suggestionsBuilder);
        filteredSuggestionList.forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        if (dispatcher.getRoot().getChildren().stream().anyMatch(node -> node.getName().equalsIgnoreCase(this.identifier))) {
            CarpetSettings.LOG.error("Failed to add settings command for " + this.identifier + ". It is masking previous command.");
            return;
        }
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)this.identifier).requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.carpetCommandPermissionLevel) && !this.locked());
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.executes(context -> this.listAllSettings((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("carpet.settings.command.all_mod_settings"), this.fancyName), this.getRulesSorted()))).then(class_2170.method_9247((String)"defaults").executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("carpet.settings.command.current_from_file_header"), this.fancyName, this.identifier + ".conf"), this.findStartupOverrides())))).then(class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(this.getCategories(), (SuggestionsBuilder)b)).executes(c -> this.listSettings((class_2168)c.getSource(), String.format(Translations.tr("carpet.settings.command.mod_settings_matching"), this.fancyName, RuleHelper.translatedCategory(this.identifier(), StringArgumentType.getString((CommandContext)c, (String)"tag"))), this.getRulesMatching(StringArgumentType.getString((CommandContext)c, (String)"tag"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removeDefault").requires(s -> !this.locked())).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SettingsManager.suggestMatchingContains(this.getRulesSorted().stream().map(CarpetRule::name), b)).executes(c -> this.removeDefault((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setDefault").requires(s -> !this.locked())).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SettingsManager.suggestMatchingContains(this.getRulesSorted().stream().map(CarpetRule::name), b)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((c, b) -> class_2172.method_9265(this.contextRule((CommandContext<class_2168>)c).suggestions(), (SuggestionsBuilder)b)).executes(c -> this.setDefault((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c), StringArgumentType.getString((CommandContext)c, (String)"value"))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SettingsManager.suggestMatchingContains(this.getRulesSorted().stream().map(CarpetRule::name), b)).requires(s -> !this.locked())).executes(c -> this.displayRuleMenu((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c)))).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((c, b) -> class_2172.method_9265(this.contextRule((CommandContext<class_2168>)c).suggestions(), (SuggestionsBuilder)b)).executes(c -> this.setRule((class_2168)c.getSource(), this.contextRule((CommandContext<class_2168>)c), StringArgumentType.getString((CommandContext)c, (String)"value")))));
        dispatcher.register(literalargumentbuilder);
    }

    private int displayRuleMenu(class_2168 source, CarpetRule<?> rule) {
        String displayName = RuleHelper.translatedName(rule);
        Messenger.m(source, "");
        Messenger.m(source, "wb " + displayName, "!/" + this.identifier + " " + rule.name(), "^g refresh");
        Messenger.m(source, "w " + RuleHelper.translatedDescription(rule));
        rule.extraInfo().forEach(s -> Messenger.m(source, s));
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        tags.add(Messenger.c("w " + Translations.tr("carpet.settings.command.tags") + ": "));
        for (String t : rule.categories()) {
            String translated = RuleHelper.translatedCategory(this.identifier(), t);
            tags.add(Messenger.c("c [" + translated + "]", "^g " + String.format(Translations.tr("carpet.settings.command.list_all_category"), translated), "!/" + this.identifier + " list " + t));
            tags.add(Messenger.c("w , "));
        }
        tags.remove(tags.size() - 1);
        Messenger.m(source, tags.toArray(new Object[0]));
        Messenger.m(source, "w " + Translations.tr("carpet.settings.command.current_value") + ": ", String.format("%s %s (%s value)", RuleHelper.getBooleanValue(rule) ? "lb" : "nb", RuleHelper.toRuleString(rule.value()), RuleHelper.isInDefaultValue(rule) ? "default" : "modified"));
        ArrayList<class_2561> options = new ArrayList<class_2561>();
        options.add(Messenger.c("w Options: ", "y [ "));
        for (String o : rule.suggestions()) {
            options.add(this.makeSetRuleButton(rule, o, false));
            options.add(Messenger.c("w  "));
        }
        options.remove(options.size() - 1);
        options.add(Messenger.c("y  ]"));
        Messenger.m(source, options.toArray(new Object[0]));
        return 1;
    }

    private int setRule(class_2168 source, CarpetRule<?> rule, String newValue) {
        try {
            rule.set(source, newValue);
            Messenger.m(source, "w " + rule.toString() + ", ", "c [" + Translations.tr("carpet.settings.command.change_permanently") + "?]", "^w " + String.format(Translations.tr("carpet.settings.command.change_permanently_tooltip"), this.identifier + ".conf"), "?/" + this.identifier + " setDefault " + rule.name() + " " + RuleHelper.toRuleString(rule.value()));
        }
        catch (InvalidRuleValueException e) {
            e.notifySource(rule.name(), source);
        }
        return 1;
    }

    private int setDefault(class_2168 source, CarpetRule<?> rule, String stringValue) {
        if (this.locked()) {
            return 0;
        }
        if (!this.rules.containsKey(rule.name())) {
            return 0;
        }
        ConfigReadResult conf = this.readSettingsFromConf(this.getFile());
        conf.ruleMap().put(rule.name(), stringValue);
        this.writeSettingsToConf(conf);
        try {
            rule.set(source, stringValue);
            Messenger.m(source, "gi " + String.format(Translations.tr("carpet.settings.command.default_set"), RuleHelper.translatedName(rule), stringValue));
        }
        catch (InvalidRuleValueException e) {
            e.notifySource(rule.name(), source);
        }
        return 1;
    }

    private int removeDefault(class_2168 source, CarpetRule<?> rule) {
        if (this.locked) {
            return 0;
        }
        if (!this.rules.containsKey(rule.name())) {
            return 0;
        }
        ConfigReadResult conf = this.readSettingsFromConf(this.getFile());
        conf.ruleMap().remove(rule.name());
        this.writeSettingsToConf(conf);
        RuleHelper.resetToDefault(this.rules.get(rule.name()), source);
        Messenger.m(source, "gi " + String.format(Translations.tr("carpet.settings.command.default_removed"), RuleHelper.translatedName(rule)));
        return 1;
    }

    private class_2561 displayInteractiveSetting(CarpetRule<?> rule) {
        String displayName = RuleHelper.translatedName(rule);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("w - " + displayName + " ");
        args.add("!/" + this.identifier + " " + rule.name());
        args.add("^y " + RuleHelper.translatedDescription(rule));
        for (String option : rule.suggestions()) {
            args.add(this.makeSetRuleButton(rule, option, true));
            args.add("w  ");
        }
        if (!rule.suggestions().contains(RuleHelper.toRuleString(rule.value()))) {
            args.add(this.makeSetRuleButton(rule, RuleHelper.toRuleString(rule.value()), true));
            args.add("w  ");
        }
        args.remove(args.size() - 1);
        return Messenger.c(args.toArray(new Object[0]));
    }

    private class_2561 makeSetRuleButton(CarpetRule<?> rule, String option, boolean brackets) {
        Object style;
        Object object = RuleHelper.isInDefaultValue(rule) ? "g" : (style = option.equalsIgnoreCase(RuleHelper.toRuleString(rule.defaultValue())) ? "e" : "y");
        if (option.equalsIgnoreCase(RuleHelper.toRuleString(rule.value()))) {
            style = (String)style + "u";
            if (option.equalsIgnoreCase(RuleHelper.toRuleString(rule.defaultValue()))) {
                style = (String)style + "b";
            }
        }
        String component = (String)style + (brackets ? " [" : " ") + option + (brackets ? "]" : "");
        if (option.equalsIgnoreCase(RuleHelper.toRuleString(rule.value()))) {
            return Messenger.c(component);
        }
        return Messenger.c(component, "^g " + Translations.tr("carpet.settings.command.switch_to").formatted(option + (option.equals(RuleHelper.toRuleString(rule.defaultValue())) ? " (default)" : "")), "?/" + this.identifier + " " + rule.name() + " " + option);
    }

    private int listSettings(class_2168 source, String title, Collection<CarpetRule<?>> settings_list) {
        Messenger.m(source, String.format("wb %s:", title));
        settings_list.forEach(e -> Messenger.m(source, this.displayInteractiveSetting((CarpetRule<?>)e)));
        return settings_list.size();
    }

    private int listAllSettings(class_2168 source) {
        int count = this.listSettings(source, String.format(Translations.tr("carpet.settings.command.current_settings_header"), this.fancyName), this.getNonDefault());
        if (this.version != null) {
            Messenger.m(source, "g " + this.fancyName + " " + Translations.tr("carpet.settings.command.version") + ": " + this.version);
        }
        ArrayList<Object> tags = new ArrayList<Object>();
        tags.add("w " + Translations.tr("carpet.settings.command.browse_categories") + ":\n");
        for (String t : this.getCategories()) {
            String translated = RuleHelper.translatedCategory(this.identifier(), t);
            String translatedPlus = !translated.equals(t) ? "%s (%s)".formatted(translated, t) : t;
            tags.add("c [" + translated + "]");
            tags.add("^g " + String.format(Translations.tr("carpet.settings.command.list_all_category"), translatedPlus));
            tags.add("!/" + this.identifier + " list " + t);
            tags.add("w  ");
        }
        tags.remove(tags.size() - 1);
        Messenger.m(source, tags.toArray(new Object[0]));
        return count;
    }

    record ConfigReadResult(Map<String, String> ruleMap, boolean locked) {
    }

    @FunctionalInterface
    public static interface RuleObserver {
        public void ruleChanged(class_2168 var1, CarpetRule<?> var2, String var3);
    }
}

