/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.translations;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.translations.TranslationConstants;
import carpettisaddition.utils.FileUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class TranslationLoader {
    private static final String RESOURCE_DIR = String.format("assets/%s/lang", TranslationConstants.TRANSLATION_NAMESPACE);

    public static void loadTranslations(Map<String, Map<String, String>> translationStorage) {
        List languageList;
        try {
            String fileContent = FileUtils.readResourceFileAsString(RESOURCE_DIR + "/meta/languages.json");
            languageList = (List)new Gson().fromJson(fileContent, LanguageList.class);
        }
        catch (Exception e) {
            CarpetTISAdditionServer.LOGGER.error("Failed to read language list", (Throwable)e);
            return;
        }
        languageList.forEach(lang -> translationStorage.computeIfAbsent((String)lang, TranslationLoader::loadTranslationFile));
    }

    private static Map<String, String> loadTranslationFile(String lang) {
        try {
            String fileContent = FileUtils.readResourceFileAsString(String.format("%s/%s.json", RESOURCE_DIR, lang));
            return (Map)new Gson().fromJson(fileContent, TranslationMapping.class);
        }
        catch (Exception e) {
            String message = "Failed to load translation of language " + lang;
            CarpetTISAdditionServer.LOGGER.error(message, (Throwable)e);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                throw new RuntimeException(message, e);
            }
            return Collections.emptyMap();
        }
    }

    private static class LanguageList
    extends ArrayList<String> {
        private LanguageList() {
        }
    }

    private static class TranslationMapping
    extends LinkedHashMap<String, String> {
        private TranslationMapping() {
        }
    }
}

