/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.movement;

import carpettisaddition.logging.loggers.movement.MovementLogger;
import carpettisaddition.logging.loggers.movement.MovementLoggerTarget;
import carpettisaddition.logging.loggers.movement.MovementModification;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class}, priority=2000)
public abstract class EntityMixin
implements MovementLoggerTarget {
    @Nullable
    private MovementLogger.Tracker movementTracker$TISCM = null;

    @Override
    public Optional<MovementLogger.Tracker> getMovementTracker() {
        return Optional.ofNullable(this.movementTracker$TISCM);
    }

    @Override
    public void setMovementTracker(@Nullable MovementLogger.Tracker tracker) {
        this.movementTracker$TISCM = tracker;
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void onMovementStart_movementLogger(class_1313 type, class_243 movement, CallbackInfo ci) {
        MovementLogger.getInstance().create((class_1297)this, type, movement);
    }

    @Inject(method={"move"}, at={@At(value="RETURN")})
    private void onMovementEnd_movementLogger(CallbackInfo ci) {
        MovementLogger.getInstance().finalize((class_1297)this);
    }

    @Inject(method={"move"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;adjustMovementForPiston(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;", shift=At.Shift.AFTER)})
    private void onMovementModified_piston(class_1313 type, class_243 movement, CallbackInfo ci) {
        this.getMovementTracker().ifPresent(tracker -> tracker.recordModification(MovementModification.PISTON, movement));
    }

    @Inject(method={"move"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;", shift=At.Shift.AFTER)})
    private void onMovementModified_sneaking(class_1313 type, class_243 movement, CallbackInfo ci) {
        this.getMovementTracker().ifPresent(tracker -> tracker.recordModification(MovementModification.SNEAKING, movement));
    }

    @ModifyVariable(method={"move"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/Entity;adjustMovementForCollisions(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;", shift=At.Shift.AFTER), ordinal=1)
    private class_243 onMovementModified_collision(class_243 movement) {
        this.getMovementTracker().ifPresent(tracker -> tracker.recordModification(MovementModification.COLLISION, movement));
        return movement;
    }
}

