/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.EventSource;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSetblockStateEvent
extends BaseEvent {
    protected final class_2680 oldBlockState;
    protected final class_2680 newBlockState;
    protected final int flags;
    @Nullable
    protected Boolean returnValue;
    private static final Translator TRANSLATOR = new BaseEvent(null, "set_block_state_event_base", (EventSource)null){

        @Override
        public class_5250 toText() {
            throw new UnsupportedOperationException();
        }
    }.getTranslator();
    private static final List<FlagData> SET_BLOCK_STATE_FLAGS = Lists.newArrayList();

    protected AbstractSetblockStateEvent(EventType eventType, String translateKey, class_2680 oldBlockState, class_2680 newBlockState, @Nullable Boolean returnValue, int flags) {
        super(eventType, translateKey, oldBlockState.method_26204());
        this.oldBlockState = oldBlockState;
        this.newBlockState = newBlockState;
        this.returnValue = returnValue;
        this.flags = flags;
    }

    protected class_5250 getFlagsText() {
        Object bits = Integer.toBinaryString(this.flags);
        bits = String.join((CharSequence)"", Collections.nCopies(Math.max(SET_BLOCK_STATE_FLAGS.size() - ((String)bits).length(), 0), "0")) + (String)bits;
        ArrayList list = Lists.newArrayList();
        list.add(Messenger.s(String.format("setBlockState flags = %d (%s)", this.flags, bits)));
        for (FlagData flagData : SET_BLOCK_STATE_FLAGS) {
            if (!flagData.isValid()) continue;
            int currentBit = (this.flags & flagData.mask) > 0 ? 1 : 0;
            list.add(Messenger.c(String.format("w \nbit %d = %d: ", flagData.bitPos, currentBit), String.format("^w 2^%d = %d", flagData.bitPos, flagData.mask), MicroTimingUtil.getSuccessText((currentBit ^ flagData.revert) != 0, false), "w  ", TRANSLATOR.tr("flag_data." + flagData.bitPos, new Object[0])));
        }
        return Messenger.c(list.toArray(new Object[0]));
    }

    @Override
    public void mergeQuitEvent(BaseEvent quitEvent) {
        super.mergeQuitEvent(quitEvent);
        if (quitEvent instanceof AbstractSetblockStateEvent) {
            this.returnValue = ((AbstractSetblockStateEvent)quitEvent).returnValue;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSetblockStateEvent that = (AbstractSetblockStateEvent)o;
        return this.flags == that.flags && Objects.equals(this.oldBlockState, that.oldBlockState) && Objects.equals(this.newBlockState, that.newBlockState) && Objects.equals(this.returnValue, that.returnValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oldBlockState, this.newBlockState, this.flags, this.returnValue);
    }

    static {
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(0, false));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(1, false));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(2, true));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(3, false));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(4, true));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(5, true));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(6, false));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(7, true));
        SET_BLOCK_STATE_FLAGS.add(FlagData.of(8, true));
    }

    private static class FlagData {
        private final int mask;
        private final int revert;
        private final int bitPos;
        private final boolean valid;

        private FlagData(int bitPos, boolean revert, boolean valid) {
            this.valid = valid;
            this.revert = revert ? 1 : 0;
            this.mask = 1 << bitPos;
            this.bitPos = bitPos;
        }

        private static FlagData of(int bitPos, boolean revert) {
            return new FlagData(bitPos, revert, true);
        }

        private static FlagData dummy() {
            return new FlagData(0, false, false);
        }

        private boolean isValid() {
            return this.valid;
        }
    }
}

