/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.raycast;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.raycast.RaycastSimulator;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.CommandUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class RaycastCommand
extends AbstractCommand {
    private static final String NAME = "raycast";
    private static final RaycastCommand INSTANCE = new RaycastCommand();

    private RaycastCommand() {
        super(NAME);
    }

    public static RaycastCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        context.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(s -> CarpetModUtil.canUseCommand(s, CarpetTISAdditionSettings.commandRaycast))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"emsim").requires(s -> CarpetTISAdditionSettings.ultraSecretSetting.equals("endermelon"))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"max_r", (ArgumentType)IntegerArgumentType.integer()).executes(c -> this.endermenlonSimulate((class_2168)c.getSource(), class_2262.method_9696((CommandContext)c, (String)"pos"), IntegerArgumentType.getInteger((CommandContext)c, (String)"max_r"))))))).then(class_2170.method_9247((String)"block").then(class_2170.method_9244((String)"start", (ArgumentType)class_2277.method_9737()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"end", (ArgumentType)class_2277.method_9737()).executes(this::performRaycast)).then(((RequiredArgumentBuilder)CommandUtils.enumArg("shapeMode", class_3959.class_3960.class).executes(this::performRaycast)).then(CommandUtils.enumArg("fluidMode", class_3959.class_242.class).executes(this::performRaycast)))))));
    }

    private int endermenlonSimulate(class_2168 source, class_2338 pos, int maxR) throws CommandSyntaxException {
        new RaycastSimulator((class_1937)source.method_9225(), source.method_9229()).simulate(pos, maxR);
        return 0;
    }

    private <T extends Enum<?>> T getEnumArg(CommandContext<?> context, String argName, T def) throws CommandSyntaxException {
        String enumString;
        try {
            enumString = StringArgumentType.getString(context, (String)argName);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
        try {
            return (T)Enum.valueOf(def.getClass(), enumString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            class_5250 msg = Messenger.formatting(this.tr("unknown_enum." + argName, enumString), class_124.field_1061);
            throw new SimpleCommandExceptionType((Message)msg).create();
        }
    }

    private int performRaycast(CommandContext<class_2168> c) throws CommandSyntaxException {
        class_243 start = class_2277.method_9736(c, (String)"start");
        class_243 end = class_2277.method_9736(c, (String)"end");
        class_3959.class_3960 shapeMode = this.getEnumArg(c, "shapeMode", class_3959.class_3960.field_17558);
        class_3959.class_242 fluidMode = this.getEnumArg(c, "fluidMode", class_3959.class_242.field_1348);
        class_2168 source = (class_2168)c.getSource();
        class_3218 world = source.method_9225();
        class_3965 result = world.method_17742(new class_3959(start, end, shapeMode, fluidMode, source.method_9229()));
        if (result.method_17783() == class_239.class_240.field_1333) {
            Messenger.tell(source, Messenger.formatting(this.tr("missed", new Object[0]), class_124.field_1079));
            return 0;
        }
        class_5250 coordText = Messenger.coord((class_2382)result.method_17777(), DimensionWrapper.of((class_1937)world));
        class_5250 blockText = Messenger.fancy(Messenger.block(world.method_8320(result.method_17777())), coordText, coordText.method_10866().method_10970());
        Function<class_243, class_5250> c2t = coord -> Messenger.coord(coord, DimensionWrapper.of((class_1937)world));
        Messenger.tell(source, Messenger.c(Messenger.fancy("l", this.tr("hit", new Object[0]), Messenger.format("%s -> %s", c2t.apply(start), c2t.apply(end)), null), Messenger.s(" "), Messenger.formatting(blockText, class_124.field_1075), "g  @ ", c2t.apply(result.method_17784())));
        return 1;
    }
}

