/*
 * Decompiled with CFR 0.152.
 */
package net.ramixin.visibletraders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1646;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_3850;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedTradeData {
    private static final Logger visibleTradersLogger = LoggerFactory.getLogger((String)"Visible Traders");
    private List<class_1916> lockedOffers;

    public LockedTradeData(class_1646 villager) {
        this.lockedOffers = LockedTradeData.generateTrades(villager);
    }

    public LockedTradeData(class_11368 valueInput) {
        Optional offers = valueInput.method_71426("LockedOffers", class_1916.field_48850.listOf());
        this.lockedOffers = offers.map(ArrayList::new).orElse(null);
    }

    private LockedTradeData(List<class_1916> offers) {
        this.lockedOffers = new ArrayList<class_1916>(offers);
    }

    @Nullable
    public static LockedTradeData constructOrNull(class_11368 valueInput) {
        Optional offers = valueInput.method_71426("LockedOffers", class_1916.field_48850.listOf());
        return offers.map(LockedTradeData::new).orElse(null);
    }

    private static ArrayList<class_1916> generateTrades(class_1646 villager) {
        class_1916 offers = villager.method_8264();
        class_3850 data = villager.method_7231();
        ArrayList<class_1916> lockedOffers = new ArrayList<class_1916>();
        int level = data.comp_3522();
        while (level < 5) {
            villager.method_7195(data.method_16920(++level));
            int prev = offers.size();
            villager.method_7237();
            int dif = offers.size() - prev;
            class_1916 newOffers = new class_1916();
            for (int i = 0; i < dif; ++i) {
                newOffers.add((Object)((class_1914)offers.removeLast()));
            }
            lockedOffers.add(newOffers);
        }
        villager.method_7195(data);
        return lockedOffers;
    }

    public void write(class_11372 valueOutput) {
        if (this.lockedOffers == null) {
            return;
        }
        valueOutput.method_71468("LockedOffers", class_1916.field_48850.listOf(), this.lockedOffers);
    }

    public boolean hasNoOffers() {
        return this.lockedOffers.isEmpty();
    }

    public class_1916 popTradeSet() {
        if (this.lockedOffers == null || this.hasNoOffers()) {
            return null;
        }
        return this.lockedOffers.removeFirst();
    }

    public class_1916 buildLockedOffers() {
        class_1916 lockedOffers = new class_1916();
        if (this.lockedOffers == null) {
            return lockedOffers;
        }
        for (class_1916 listOffers : this.lockedOffers) {
            for (class_1914 offer : listOffers) {
                if (offer.method_8250().method_7960()) {
                    this.lockedOffers = new ArrayList<class_1916>();
                    visibleTradersLogger.error("detected incomplete trade. Rebuilding locked offers");
                    return new class_1916();
                }
                lockedOffers.add((Object)offer);
            }
        }
        return lockedOffers;
    }

    public void tick(class_1646 villager, Runnable popCallback) {
        if (this.lockedOffers == null) {
            return;
        }
        int requiredSets = 5 - villager.method_7231().comp_3522();
        while (requiredSets < this.lockedOffers.size()) {
            popCallback.run();
        }
        if (requiredSets > this.lockedOffers.size()) {
            visibleTradersLogger.error("detected missing locked trade sets. Rebuilding locked offers");
            this.lockedOffers = LockedTradeData.generateTrades(villager);
        }
    }
}

