/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import io.github.reserveword.imblocker.common.accessor.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.Dimension;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseWidget.class}, remap=false)
public abstract class SM642WidgetMixin
implements MinecraftFocusableWidget {
    @Unique
    protected BaseWidget parent;
    @Shadow
    protected int x;
    @Shadow
    protected int y;
    @Shadow
    protected int width;
    @Shadow
    protected int height;

    @Inject(method={"addWidget"}, at={@At(value="TAIL")})
    public <T extends Widget> void onWidgetAdded(T widget, CallbackInfoReturnable<T> cir) {
        if (widget instanceof BaseWidget) {
            ((SM642WidgetMixin)widget).parent = (BaseWidget)this;
        }
    }

    @Override
    public Rectangle getBoundsAbs() {
        int xAbs = this.x;
        int yAbs = this.y;
        SM642WidgetMixin root = this;
        SM642WidgetMixin parent = (SM642WidgetMixin)this.parent;
        while (parent != null) {
            xAbs += parent.x;
            yAbs += parent.y;
            root = parent;
            parent = (SM642WidgetMixin)parent.parent;
        }
        double renderScale = this.getGuiScale();
        Rectangle scaledBounds = new Rectangle(renderScale, xAbs, yAbs, this.width, this.height);
        Dimension gameContentSize = MinecraftClientAccessor.INSTANCE.getContentSize();
        int offsetX = (int)(((double)gameContentSize.width() - (double)root.width * renderScale) / 2.0);
        int offsetY = (int)(((double)gameContentSize.height() - (double)root.height * renderScale) / 2.0);
        return new Rectangle(offsetX + scaledBounds.x(), offsetY + scaledBounds.y(), scaledBounds.width(), scaledBounds.height());
    }
}

