/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.TextStorageImpl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextView;
import com.apple.library.uikit.UIView;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={UITextField.class, UITextView.class}, remap=false)
public abstract class AWTextInputWidgetMixin
implements MinecraftFocusableWidget {
    @Shadow(remap=false)
    private TextStorageImpl storage;
    private float imblocker$scale = 1.0f;
    private Rectangle imblocker$bounds = Rectangle.EMPTY;
    private Point imblocker$caretPos = Point.TOP_LEFT;

    @Inject(method={"becomeFirstResponder"}, at={@At(value="TAIL")})
    public void focusGained(CallbackInfo ci) {
        this.imblocker$onFocusGained();
    }

    @Inject(method={"resignFirstResponder"}, at={@At(value="TAIL")})
    public void focusLost(CallbackInfo ci) {
        this.imblocker$onFocusLost();
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(UIEvent event, CallbackInfo ci) {
        if (FocusManager.isTrackingFocus) {
            if (this.storage.isFocused()) {
                FocusContainer.MINECRAFT.switchFocus(this);
            }
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/apple/library/impl/TextStorageImpl;render(Lcom/apple/library/coregraphics/CGPoint;Lcom/apple/library/coregraphics/CGGraphicsContext;)V", shift=At.Shift.AFTER)})
    public void updateCaretPos(CGPoint point, CGGraphicsContext context, CallbackInfo ci) {
        if (!this.isTrulyFocused()) {
            return;
        }
        CGRect clip = context.boundingBoxOfClipPath();
        CGRect rawBounds = ((UIView)this).bounds().insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        float currentScale = clip.height / rawBounds.height;
        if (this.imblocker$scale != currentScale) {
            this.imblocker$scale = currentScale;
            IMManager.updateCompositionFontSize();
        }
        Rectangle currentBounds = new Rectangle((int)clip.x, (int)clip.y, (int)clip.width, (int)clip.height);
        CGRect cursorRect = this.storage.cursorRect();
        CGPoint contentOffset = UIScrollView.class.isInstance(this) ? ((UIScrollView)this).contentOffset() : CGPoint.ZERO;
        Point currenetCaretPos = new Point((int)(this.storage.offset.x + cursorRect.x - contentOffset.x), (int)(this.storage.offset.y + cursorRect.y + (cursorRect.height - 1.0f - (float)this.getFontHeight()) / 2.0f - contentOffset.y));
        boolean boundsChanged = false;
        boolean caretPosChanged = false;
        boundsChanged = !currentBounds.equals(this.imblocker$bounds);
        if (boundsChanged) {
            this.imblocker$bounds = currentBounds;
        }
        if (caretPosChanged = !currenetCaretPos.equals(this.imblocker$caretPos)) {
            this.imblocker$caretPos = currenetCaretPos;
        }
        if (boundsChanged || caretPosChanged) {
            IMManager.updateCompositionWindowPos();
        }
    }

    @Override
    public Rectangle getBoundsAbs() {
        return this.imblocker$bounds.derive(this.getGuiScale());
    }

    @Override
    public Point getCaretPos() {
        return this.imblocker$caretPos.derive(this.getGuiScale() * (double)this.imblocker$scale);
    }

    @Override
    public int getFontHeight() {
        return (int)(8.0f * this.imblocker$scale);
    }
}

