/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common;

import com.sun.jna.Platform;
import io.github.reserveword.imblocker.common.EnglishStateImpl;
import io.github.reserveword.imblocker.common.IMBlockerConfig;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.IMManagerLinux;
import io.github.reserveword.imblocker.common.IMManagerMac;
import io.github.reserveword.imblocker.common.IMManagerStub;
import io.github.reserveword.imblocker.common.IMManagerWindows;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.FocusableObject;

public final class IMManager {
    private static final PlatformIMManager INSTANCE;

    private IMManager() {
    }

    public static void setState(boolean on) {
        IMBlockerCore.invokeOnMainThread(() -> INSTANCE.setState(on));
    }

    public static void setEnglishState(boolean isEN) {
        if (IMBlockerConfig.INSTANCE.isConversionStatusApiEnabled()) {
            IMBlockerCore.invokeOnMainThread(() -> INSTANCE.setEnglishState(isEN));
        }
    }

    public static void updateCompositionWindowPos() {
        if (IMBlockerConfig.INSTANCE.isCursorPositionTrackingEnabled()) {
            IMBlockerCore.invokeOnMainThread(() -> INSTANCE.updateCompositionWindowPos());
        }
    }

    public static void updateCompositionFontSize() {
        if (IMBlockerConfig.INSTANCE.isCompositionFontTweaksEnabled()) {
            IMBlockerCore.invokeOnMainThread(() -> INSTANCE.updateCompositionFontSize());
        }
    }

    public static void evaluateKeyInput(boolean isUnlockIMEKey, int action, int modifiers) {
        FocusableObject focusOwner;
        if (IMBlockerConfig.INSTANCE.getEnglishStateImpl() == EnglishStateImpl.DISABLE_IM && isUnlockIMEKey && (modifiers & 0xE) == 0 && action == 0 && (focusOwner = FocusManager.getFocusOwner()) != null && focusOwner.getPreferredState()) {
            IMManager.setState(true);
        }
    }

    static {
        if (Platform.isWindows()) {
            INSTANCE = new IMManagerWindows();
        } else if (Platform.isMac()) {
            INSTANCE = new IMManagerMac();
        } else if (Platform.isLinux()) {
            INSTANCE = new IMManagerLinux();
        } else {
            IMBlockerCore.LOGGER.warn("[IMBlocker] Unsupported platform, using stub");
            INSTANCE = new IMManagerStub();
        }
    }

    public static interface PlatformIMManager {
        public void setState(boolean var1);

        public void setEnglishState(boolean var1);

        default public void updateCompositionWindowPos() {
        }

        default public void updateCompositionFontSize() {
        }
    }
}

